import React from "react";
import "./UsageLimits.css";
import SectionHeader from "../../layouts/SectionHeader";
import CButton from "../../components/CButton";
import { useTranslation } from "react-i18next";

const UsageLimits: React.FC = () => {
  const { t } = useTranslation();

  return (
    <div className="usagelimits wrapper">
      <SectionHeader to="/home/manage-apps" />

      <div className="usagelimits__content">
        <div>
          <h3>{t("usageLimits.title")}</h3>
          <p>{t("usageLimits.desc")}</p>
          <p>{t("usageLimits.allowedApps")}</p>
        </div>

        <CButton title={t("button.save")} />
      </div>
    </div>
  );
};

export default UsageLimits;
