import { TG_USER_ID } from "../constants/constants";

export const generateDeviceId = (): string => {
  let id = localStorage.getItem(`device_id-${TG_USER_ID}`);

  if (!id) {
    if (crypto.randomUUID) {
      id = crypto.randomUUID();
    } else {
      id = "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, (c) => {
        const r = (Math.random() * 16) | 0;
        const v = c === "x" ? r : (r & 0x3) | 0x8;
        return v.toString(16);
      });
    }

    localStorage.setItem(`device_id-${TG_USER_ID}`, id);
  }

  return id;
};
