import React, { useEffect, useState } from "react";
import "./Terms.css";
import { useTranslation } from "react-i18next";
import { BiArrowBack } from "react-icons/bi";
import { Link } from "react-router-dom";

const Terms: React.FC = () => {
  const { i18n } = useTranslation();
  const [html, setHtml] = useState<string>("");

  useEffect(() => {
    const loadTerms = async () => {
      try {
        const lang = i18n.language === "uz" ? "en" : i18n.language;
        const response = await fetch(`/texts/terms/${lang}.html`);
        const text = await response.text();

        setHtml(text);
      } catch (err) {
        console.error("Failed to load terms:", err);
      }
    };

    loadTerms();
  }, [i18n.language]);

  return (
    <div className="wrapper terms">
      <Link to={"/auth/register"} className="terms__back__link">
        <BiArrowBack />
      </Link>

      <div
        dangerouslySetInnerHTML={{ __html: html }}
        className="terms__content"
      />
    </div>
  );
};

export default Terms;
