import React from "react";
import {
  createBrowserRouter,
  Navigate,
  RouterProvider,
} from "react-router-dom";
import NotFound from "../pages/NotFound";
import Login from "../pages/Auth/Login";
import Register from "../pages/Auth/Register";
import Recover from "../pages/Auth/Recover";
import Layout from "./Layout";
import ProtectedRoute from "./ProtectedRoute";
import Home from "../pages/Home";
import Notifications from "../pages/Notifications";
import Subscription from "../pages/Subscription";
import Settings from "../pages/Settings";
import Pincode from "../pages/Pincode";
import { TG_USER_ID } from "../constants/constants";

const Router: React.FC = () => {
  const isAuthenticated = !!localStorage.getItem(`token-${TG_USER_ID}`);

  const router = createBrowserRouter([
    {
      path: "/",
      element: isAuthenticated && <Navigate to={"/home"} />,
      children: [
        {
          path: "/auth/login",
          element: <Login />,
        },
        {
          path: "/auth/register",
          element: <Register />,
        },
        {
          path: "/auth/recover",
          element: <Recover />,
        },
      ],
    },
    {
      path: "/",
      element: <ProtectedRoute element={<Layout />} redirectTo="/" />,
      children: [
        {
          path: "home",
          element: <Home />,
        },
        {
          path: "notifications",
          element: <Notifications />,
        },
        {
          path: "subscription",
          element: <Subscription />,
        },
        {
          path: "settings",
          element: <Settings />,
        },
      ],
    },
    {
      path: "/pincode",
      element: <Pincode />,
    },
    {
      path: "*",
      element: <NotFound />,
    },
  ]);

  return <RouterProvider router={router} />;
};

export default Router;
