import React, { useEffect, useState } from "react";
import "./Privacy.css";
import { useTranslation } from "react-i18next";
import { BiArrowBack } from "react-icons/bi";
import { Link } from "react-router-dom";

const Privacy: React.FC = () => {
  const { i18n } = useTranslation();
  const [html, setHtml] = useState<string>("");

  useEffect(() => {
    const loadPrivacy = async () => {
      try {
        const response = await fetch(`/texts/privacy/${i18n.language}.html`);
        const text = await response.text();
        setHtml(text);
      } catch (err) {
        console.error("Failed to load privacy:", err);
      }
    };

    loadPrivacy();
  }, [i18n.language]);

  return (
    <div className="wrapper">
      <Link to={"/auth/register"} className="privacy__back__link">
        <BiArrowBack />
      </Link>
      <div
        dangerouslySetInnerHTML={{ __html: html }}
        className="privacy__content"
      />
    </div>
  );
};

export default Privacy;
