import type { ReactNode } from "react";
import {
  IoLogoFacebook,
  IoLogoInstagram,
  IoLogoVk,
  IoLogoWhatsapp,
} from "react-icons/io5";
import { SiTelegram, SiViber } from "react-icons/si";

export interface IMessenger {
  id: number;
  name: string;
  icon: ReactNode;
}

export const MESSENGERS: IMessenger[] = [
  {
    id: 20,
    name: "Telegram",
    icon: <SiTelegram className="messenger__icon" />,
  },
  {
    id: 7,
    name: "WhatsApp",
    icon: <IoLogoWhatsapp className="messenger__icon" />,
  },
  {
    id: 6,
    name: "VK",
    icon: <IoLogoVk className="messenger__icon" />,
  },
  {
    id: 22,
    name: "Instagram",
    icon: <IoLogoInstagram className="messenger__icon" />,
  },
  {
    id: 10,
    name: "Facebook",
    icon: <IoLogoFacebook className="messenger__icon" />,
  },
  {
    id: 8,
    name: "Viber",
    icon: <SiViber className="messenger__icon" />,
  },
];
