import { createRoot } from "react-dom/client";
import "./styles/global.css";
import App from "./App.tsx";
import { Provider } from "react-redux";
import { store } from "./stores/store.ts";
import "./locales/i18n.ts";
import { ThemeProvider } from "./contexts/ThemeContext/ThemeProvider.tsx";
import { LanguageProvider } from "./contexts/LanguageContext/LanguageProvider.tsx";
import { AuthProvider } from "./contexts/AuthContext/AuthContext.tsx";

createRoot(document.getElementById("root")!).render(
  <Provider store={store}>
    <AuthProvider>
      <ThemeProvider>
        <LanguageProvider>
          <App />
        </LanguageProvider>
      </ThemeProvider>
    </AuthProvider>
  </Provider>
);
