import React from "react";
import "./Settings.css";
import { useLanguage } from "../../contexts/LanguageContext/useLanguage";
import CSelect from "../../components/CSelect";
import en from "../../assets/images/flag-en.png";
import ru from "../../assets/images/flag-ru.png";
import { FiUserMinus } from "react-icons/fi";
import { IoKeyOutline } from "react-icons/io5";
import { MdOutlineLogout } from "react-icons/md";
import { useTranslation } from "react-i18next";

const Settings: React.FC = () => {
  const { language, changeLanguage } = useLanguage();
  const { t } = useTranslation();

  return (
    <div className="settings">
      <h3 className="settings__title">{t("settings.title")}</h3>

      <div className="settings__content">
        <CSelect
          value={language}
          onChange={(flag: string) => changeLanguage(flag as "en" | "ru")}
          options={[
            {
              label: "English",
              value: "en",
              image: (
                <img
                  src={en}
                  alt="en"
                  style={{ width: 20, height: 20, objectFit: "cover" }}
                />
              ),
            },
            {
              label: "Русский",
              value: "ru",
              image: (
                <img
                  src={ru}
                  alt="ru"
                  style={{ width: 20, height: 20, objectFit: "cover" }}
                />
              ),
            },
          ]}
        />

        <h3>{t("settings.account")}</h3>

        <div className="settings__content__action">
          <FiUserMinus className="settings__content__action__icon" />{" "}
          {t("settings.deleteAccount")}
        </div>

        <div className="settings__content__action">
          <IoKeyOutline className="settings__content__action__icon" />{" "}
          {t("settings.recoverPassword")}
        </div>

        <div className="settings__content__action">
          <MdOutlineLogout className="settings__content__action__icon" />{" "}
          {t("settings.logout")}
        </div>
      </div>
    </div>
  );
};

export default Settings;
