import React from "react";
import "./CButton.css";
import type { CButtonProps } from "./CButton.types";

const CButton: React.FC<CButtonProps> = ({
  title,
  onClick,
  disabled,
  variant,
  isLoading,
  style,
  className,
  type,
}) => {
  return (
    <button
      onClick={onClick}
      disabled={disabled || isLoading}
      style={style}
      className={`cbtn ${variant ? `cbtn-${variant}` : ""} ${className || ""}`}
      type={type}
    >
      <span>{title}</span>
      {isLoading && <div className="cbtn__spinner"></div>}
    </button>
  );
};

export default CButton;
