import React from "react";
import "./BrowserHistory.css";
import SectionHeader from "../../layouts/SectionHeader";
import { MdInfoOutline } from "react-icons/md";
import CButton from "../../components/CButton";

const BrowserHistory: React.FC = () => {
  return (
    <div className="browserhistory wrapper">
      <SectionHeader to="/home" />

      <div className="browserhistory__content">
        <div>
          <div className="browserhistory__content__header">
            <h3>Browser History</h3>
            <MdInfoOutline className="browserhistory__content__header__icon" />
          </div>

          <p className="browserhistory__content__empty">No data</p>
        </div>

        <div className="browserhistory__filter">
          <p className="browserhistory__filter__title">Select Dates</p>

          <div className="browserhistory__filter__dates">
            <div className="browserhistory__filter__date">
              <label htmlFor="from">From</label>
              <input type="date" id="from" />
            </div>

            <div className="browserhistory__filter__date">
              <label htmlFor="to">To</label>
              <input type="date" id="to" />
            </div>
          </div>

          <CButton title="Search" />
        </div>
      </div>
    </div>
  );
};

export default BrowserHistory;
