import React, { useEffect } from "react";
import "./News.css";
import CLoading from "../../components/CLoading";
import {
  useAppDispatch,
  useAppSelector,
  type RootState,
} from "../../stores/store";
import { fetchAllNews } from "../../stores/slices/newsSlice";

const News: React.FC = () => {
  const { news, isNewsLoading } = useAppSelector(
    (state: RootState) => state.news
  );
  const dispatch = useAppDispatch();

  useEffect(() => {
    dispatch(fetchAllNews());
  }, [dispatch]);

  return (
    <div className="news wrapper">
      {isNewsLoading && news.length === 0 && (
        <div className="cloading__center">
          <CLoading />
        </div>
      )}

      <div className="news__list">
        {news.map((item) => {
          return (
            <div className="news__item" key={item.id}>
              <div
                className="news__item__head"
                dangerouslySetInnerHTML={{ __html: item.head }}
              ></div>
              <div
                className="news__item__text"
                dangerouslySetInnerHTML={{ __html: item.text }}
              />
            </div>
          );
        })}
      </div>
    </div>
  );
};

export default News;
