import React, { useEffect, useState } from "react";
import { useTranslation } from "react-i18next";
import { BiArrowBack } from "react-icons/bi";
import { Link } from "react-router-dom";

const Terms: React.FC = () => {
  const { i18n } = useTranslation();
  const [html, setHtml] = useState<string>("");

  useEffect(() => {
    const loadTerms = async () => {
      try {
        const response = await fetch(`/texts/terms/${i18n.language}.html`);
        const text = await response.text();
        setHtml(text);
      } catch (err) {
        console.error("Failed to load terms:", err);
      }
    };

    loadTerms();
  }, [i18n.language]);

  return (
    <div className="wrapper">
      <Link
        to={"/auth/register"}
        style={{
          textDecoration: "none",
          cursor: "pointer",
          fontSize: "1.5rem",
          color: "#000000",
        }}
      >
        <BiArrowBack />
      </Link>
      <div
        dangerouslySetInnerHTML={{ __html: html }}
        style={{
          wordWrap: "break-word",
          boxSizing: "border-box",
        }}
      />
    </div>
  );
};

export default Terms;
