import React from "react";
import "./Routes.css";
import SectionHeader from "../../layouts/SectionHeader";
import CButton from "../../components/CButton";
import { MdInfoOutline } from "react-icons/md";

const Routes: React.FC = () => {
  return (
    <div className="routes wrapper">
      <SectionHeader to="/home" />

      <div className="routes__content">
        <div>
          <div className="routes__content__header">
            <h3>Routes</h3>
            <MdInfoOutline className="routes__content__header__icon" />
          </div>

          <p className="routes__content__empty">No data</p>
        </div>

        <div className="routes__filter">
          <p className="routes__filter__title">Select Dates</p>

          <div className="routes__filter__dates">
            <div className="routes__filter__date">
              <label htmlFor="from">From</label>
              <input type="date" id="from" />
            </div>

            <div className="routes__filter__date">
              <label htmlFor="to">To</label>
              <input type="date" id="to" />
            </div>
          </div>

          <CButton title="Search" />
        </div>
      </div>
    </div>
  );
};

export default Routes;
