import React from "react";
import {
  createBrowserRouter,
  Navigate,
  Outlet,
  RouterProvider,
} from "react-router-dom";
import NotFound from "../pages/NotFound";
import Login from "../pages/Auth/Login";
import Register from "../pages/Auth/Register";
import Recover from "../pages/Auth/Recover";
import Layout from "./Layout";
import ProtectedRoute from "./ProtectedRoute";
import Home from "../pages/Home";
import Notifications from "../pages/Notifications";
import Subscription from "../pages/Subscription";
import Settings from "../pages/Settings";
import Pincode from "../pages/Pincode";
import { TG_USER_ID } from "../constants/constants";
import Routes from "../pages/Routes";
import ManageApps from "../pages/ManageApps";
import BrowserHistory from "../pages/BrowserHistory";
import Messengers from "../pages/Messengers";
import Calls from "../pages/Calls";
import Permissions from "../pages/Permissions";
import Recording from "../pages/Recording";
import BlockApps from "../pages/BlockApps";
import UsageLimits from "../pages/UsageLimits";
import Terms from "../pages/Auth/Terms";
import Privacy from "../pages/Auth/Privacy";

const Router: React.FC = () => {
  const isAuthenticated = !!localStorage.getItem(`token-${TG_USER_ID}`);

  const router = createBrowserRouter([
    {
      path: "/",
      element: isAuthenticated && <Navigate to={"/home"} />,
      children: [
        {
          index: true,
          element: <Login />,
        },
        {
          path: "/auth/register",
          element: <Register />,
        },
        {
          path: "/auth/recover",
          element: <Recover />,
        },
        {
          path: "/auth/terms",
          element: <Terms />,
        },
        {
          path: "/auth/privacy",
          element: <Privacy />,
        },
      ],
    },
    {
      path: "/",
      element: <ProtectedRoute element={<Layout />} redirectTo="/" />,
      children: [
        {
          path: "home",
          element: <Home />,
        },
        {
          path: "notifications",
          element: <Notifications />,
        },
        {
          path: "subscription",
          element: <Subscription />,
        },
        {
          path: "settings",
          element: <Settings />,
        },
      ],
    },
    {
      path: "/home",
      element: <ProtectedRoute element={<Outlet />} redirectTo="/" />,
      children: [
        {
          path: "routes",
          element: <Routes />,
        },
        {
          path: "manage-apps",
          children: [
            {
              index: true,
              element: <ManageApps />,
            },
            {
              path: "block-apps",
              element: <BlockApps />,
            },
            {
              path: "usage-limits",
              element: <UsageLimits />,
            },
          ],
        },
        {
          path: "browser-history",
          element: <BrowserHistory />,
        },
        {
          path: "messengers",
          element: <Messengers />,
        },
        {
          path: "calls",
          element: <Calls />,
        },
        {
          path: "permissions",
          element: <Permissions />,
        },
        {
          path: "recording",
          element: <Recording />,
        },
      ],
    },
    {
      path: "/pincode",
      element: <Pincode />,
    },
    {
      path: "*",
      element: <NotFound />,
    },
  ]);

  return <RouterProvider router={router} />;
};

export default Router;
