import React from "react";
import "./CInfo.css";
import CModal from "../CModal";
import { useTranslation } from "react-i18next";
import CButton from "../CButton";
import { FaApple } from "react-icons/fa";
import { BsAndroid2 } from "react-icons/bs";

interface CInfoProps {
  isOpen: boolean;
  onToggle: () => void;
}

const CInfo: React.FC<CInfoProps> = ({ isOpen, onToggle }) => {
  const { t } = useTranslation();

  const share = () => {
    const message = "https://t.me/CyberNannyAppBot";

    if (window.Telegram?.WebApp?.openTelegramLink) {
      window.Telegram.WebApp.openTelegramLink(
        `https://t.me/share/url?url=${encodeURIComponent(message)}`
      );
    }
  };

  return (
    <CModal
      isOpen={isOpen}
      onToggle={onToggle}
      content={
        <div className="modal__box">
          <h3 className="modal__box__title">{t("help.howToStart")}</h3>
          <div>
            <h4>{t("help.parentPhone")}</h4>
            <p>{t("help.parentPhoneDesc1")}</p>
            <p>{t("help.parentPhoneDesc2")}</p>
            <p>{t("help.parentPhoneDesc3")}</p>
          </div>

          <div>
            <h4>{t("help.childPhone")}</h4>
            <p>{t("help.childPhoneDesc1")}</p>
            <p>{t("help.childPhoneDesc2")}</p>
            <p>{t("help.childPhoneDesc3")}</p>
          </div>

          <br />

          <p>{t("help.howToStartDesc")}</p>

          <a
            href="https://apps.apple.com/uz/app/%D0%BA%D0%B8%D0%B1%D0%B5%D1%80%D0%BD%D1%8F%D0%BD%D1%8F/id6740760058"
            target="_blank"
            rel="noopener noreferrer"
            className="cinfo__download__link"
          >
            {t("common.downloadForIos")}
            <FaApple />
          </a>

          <a
            href="https://play.google.com/store/apps/details?id=com.thecybernanny.adroapp"
            target="_blank"
            rel="noopener noreferrer"
            className="cinfo__download__link"
          >
            {t("common.downloadForAndroid")}
            <BsAndroid2 />
          </a>

          <div className="modal__box__actions">
            <CButton
              title={t("button.share")}
              variant="primary"
              onClick={share}
            />

            <CButton
              title={t("button.ok")}
              onClick={onToggle}
              variant="primary"
            />
          </div>
        </div>
      }
    />
  );
};

export default CInfo;
