export interface ITimezone {
  id: string;
  ianaId: string;
  name: string;
  abbreviation: string;
  offset: number;
}

export const TIME_ZONES: ITimezone[] = [
  {
    id: "Dateline Standard Time",
    ianaId: "Etc/GMT+12",
    name: "(UTC-12:00) International Date Line West",
    abbreviation: "(UTC Standard Time-12)",
    offset: -12,
  },
  {
    id: "UTC-11",
    ianaId: "Etc/GMT+11",
    name: "(UTC-11:00) Coordinated Universal Time-11",
    abbreviation: "(UTC Standard Time-11)",
    offset: -11,
  },
  {
    id: "Aleutian Standard Time",
    ianaId: "America/Adak",
    name: "(UTC-10:00) Aleutian Islands",
    abbreviation: "(HAST)",
    offset: -10,
  },
  {
    id: "Hawaiian Standard Time",
    ianaId: "Pacific/Honolulu",
    name: "(UTC-10:00) Hawaii",
    abbreviation: "(HST)",
    offset: -10,
  },
  {
    id: "Marquesas Standard Time",
    ianaId: "Pacific/Marquesas",
    name: "(UTC-09:30) Marquesas Islands",
    abbreviation: "(French Polynesia Standard Time)",
    offset: -9.5,
  },
  {
    id: "Alaskan Standard Time",
    ianaId: "America/Anchorage",
    name: "(UTC-09:00) Alaska",
    abbreviation: "(AKST)",
    offset: -9,
  },
  {
    id: "UTC-09",
    ianaId: "Etc/GMT+9",
    name: "(UTC-09:00) Coordinated Universal Time-09",
    abbreviation: "(UTC Standard Time-9)",
    offset: -9,
  },
  {
    id: "Yukon Standard Time",
    ianaId: "America/Whitehorse",
    name: "(UTC-07:00) Yukon",
    abbreviation: "(MST)",
    offset: -7,
  },
  {
    id: "Pacific Standard Time (Mexico)",
    ianaId: "America/Tijuana",
    name: "(UTC-08:00) Baja California",
    abbreviation: "(PST)",
    offset: -8,
  },
  {
    id: "UTC-08",
    ianaId: "Etc/GMT+8",
    name: "(UTC-08:00) Coordinated Universal Time-08",
    abbreviation: "(UTC Standard Time-8)",
    offset: -8,
  },
  {
    id: "Pacific Standard Time",
    ianaId: "America/Los_Angeles",
    name: "(UTC-08:00) Pacific Time (US & Canada)",
    abbreviation: "(PST)",
    offset: -8,
  },
  {
    id: "US Mountain Standard Time",
    ianaId: "America/Phoenix",
    name: "(UTC-07:00) Arizona",
    abbreviation: "(MST)",
    offset: -7,
  },
  {
    id: "Mountain Standard Time (Mexico)",
    ianaId: "America/Chihuahua",
    name: "(UTC-07:00) Chihuahua, La Paz, Mazatlan",
    abbreviation: "(Mexico Standard Time)",
    offset: -7,
  },
  {
    id: "Mountain Standard Time",
    ianaId: "America/Denver",
    name: "(UTC-07:00) Mountain Time (US & Canada)",
    abbreviation: "(MST)",
    offset: -7,
  },
  {
    id: "Central America Standard Time",
    ianaId: "America/Guatemala",
    name: "(UTC-06:00) Central America",
    abbreviation: "(CST)",
    offset: -6,
  },
  {
    id: "Central Standard Time",
    ianaId: "America/Chicago",
    name: "(UTC-06:00) Central Time (US & Canada)",
    abbreviation: "(CST)",
    offset: -6,
  },
  {
    id: "Easter Island Standard Time",
    ianaId: "Pacific/Easter",
    name: "(UTC-06:00) Easter Island",
    abbreviation: "(Chile Standard Time)",
    offset: -6,
  },
  {
    id: "Central Standard Time (Mexico)",
    ianaId: "America/Mexico_City",
    name: "(UTC-06:00) Guadalajara, Mexico City, Monterrey",
    abbreviation: "(CST)",
    offset: -6,
  },
  {
    id: "Canada Central Standard Time",
    ianaId: "America/Regina",
    name: "(UTC-06:00) Saskatchewan",
    abbreviation: "(CST)",
    offset: -6,
  },
  {
    id: "SA Pacific Standard Time",
    ianaId: "America/Bogota",
    name: "(UTC-05:00) Bogota, Lima, Quito, Rio Branco",
    abbreviation: "(Colombia Standard Time)",
    offset: -5,
  },
  {
    id: "Eastern Standard Time (Mexico)",
    ianaId: "America/Cancun",
    name: "(UTC-05:00) Chetumal",
    abbreviation: "(EST)",
    offset: -5,
  },
  {
    id: "Eastern Standard Time",
    ianaId: "America/New_York",
    name: "(UTC-05:00) Eastern Time (US & Canada)",
    abbreviation: "(EST)",
    offset: -5,
  },
  {
    id: "Haiti Standard Time",
    ianaId: "America/Port-au-Prince",
    name: "(UTC-05:00) Haiti",
    abbreviation: "(EST)",
    offset: -5,
  },
  {
    id: "Cuba Standard Time",
    ianaId: "America/Havana",
    name: "(UTC-05:00) Havana",
    abbreviation: "(Cuba Standard Time)",
    offset: -5,
  },
  {
    id: "US Eastern Standard Time",
    ianaId: "America/Indiana/Indianapolis",
    name: "(UTC-05:00) Indiana (East)",
    abbreviation: "(EST)",
    offset: -5,
  },
  {
    id: "Turks And Caicos Standard Time",
    ianaId: "America/Grand_Turk",
    name: "(UTC-05:00) Turks and Caicos",
    abbreviation: "(EST)",
    offset: -5,
  },
  {
    id: "Paraguay Standard Time",
    ianaId: "America/Asuncion",
    name: "(UTC-04:00) Asuncion",
    abbreviation: "(Paraguay Standard Time)",
    offset: -4,
  },
  {
    id: "Atlantic Standard Time",
    ianaId: "America/Halifax",
    name: "(UTC-04:00) Atlantic Time (Canada)",
    abbreviation: "(AST)",
    offset: -4,
  },
  {
    id: "Venezuela Standard Time",
    ianaId: "America/Caracas",
    name: "(UTC-04:00) Caracas",
    abbreviation: "(Venezuela Standard Time)",
    offset: -4,
  },
  {
    id: "Central Brazilian Standard Time",
    ianaId: "America/Cuiaba",
    name: "(UTC-04:00) Cuiaba",
    abbreviation: "(Brazil Standard Time)",
    offset: -4,
  },
  {
    id: "SA Western Standard Time",
    ianaId: "America/La_Paz",
    name: "(UTC-04:00) Georgetown, La Paz, Manaus, San Juan",
    abbreviation: "(Bolivia Standard Time)",
    offset: -4,
  },
  {
    id: "Pacific SA Standard Time",
    ianaId: "America/Santiago",
    name: "(UTC-04:00) Santiago",
    abbreviation: "(Chile Standard Time)",
    offset: -4,
  },
  {
    id: "Newfoundland Standard Time",
    ianaId: "America/St_Johns",
    name: "(UTC-03:30) Newfoundland",
    abbreviation: "(NST)",
    offset: -3.5,
  },
  {
    id: "Tocantins Standard Time",
    ianaId: "America/Araguaina",
    name: "(UTC-03:00) Araguaina",
    abbreviation: "(Brazil Standard Time)",
    offset: -3,
  },
  {
    id: "E. South America Standard Time",
    ianaId: "America/Sao_Paulo",
    name: "(UTC-03:00) Brasilia",
    abbreviation: "(Brazil Standard Time)",
    offset: -3,
  },
  {
    id: "SA Eastern Standard Time",
    ianaId: "America/Cayenne",
    name: "(UTC-03:00) Cayenne, Fortaleza",
    abbreviation: "(French Guiana Standard Time)",
    offset: -3,
  },
  {
    id: "Argentina Standard Time",
    ianaId: "America/Argentina/Buenos_Aires",
    name: "(UTC-03:00) City of Buenos Aires",
    abbreviation: "(Argentina Standard Time)",
    offset: -3,
  },
  {
    id: "Greenland Standard Time",
    ianaId: "America/Nuuk",
    name: "(UTC-03:00) Greenland",
    abbreviation: "(Greenland Standard Time)",
    offset: -3,
  },
  {
    id: "Montevideo Standard Time",
    ianaId: "America/Montevideo",
    name: "(UTC-03:00) Montevideo",
    abbreviation: "(Uruguay Standard Time)",
    offset: -3,
  },
  {
    id: "Magallanes Standard Time",
    ianaId: "America/Punta_Arenas",
    name: "(UTC-03:00) Punta Arenas",
    abbreviation: "(Chile Standard Time)",
    offset: -3,
  },
  {
    id: "Saint Pierre Standard Time",
    ianaId: "America/Miquelon",
    name: "(UTC-03:00) Saint Pierre and Miquelon",
    abbreviation: "(St. Pierre & Miquelon Standard Time)",
    offset: -3,
  },
  {
    id: "Bahia Standard Time",
    ianaId: "America/Bahia",
    name: "(UTC-03:00) Salvador",
    abbreviation: "(Brazil Standard Time)",
    offset: -3,
  },
  {
    id: "UTC-02",
    ianaId: "Etc/GMT+2",
    name: "(UTC-02:00) Coordinated Universal Time-02",
    abbreviation: "(UTC Standard Time-2)",
    offset: -2,
  },
  {
    id: "Mid-Atlantic Standard Time",
    ianaId: "Etc/GMT+2",
    name: "(UTC-02:00) Mid-Atlantic - Old",
    abbreviation: "(UTC Standard Time-2)",
    offset: -2,
  },
  {
    id: "Azores Standard Time",
    ianaId: "Atlantic/Azores",
    name: "(UTC-01:00) Azores",
    abbreviation: "(Portugal Standard Time)",
    offset: -1,
  },
  {
    id: "Cape Verde Standard Time",
    ianaId: "Atlantic/Cape_Verde",
    name: "(UTC-01:00) Cabo Verde Is.",
    abbreviation: "(Cape Verde Standard Time)",
    offset: -1,
  },
  {
    id: "UTC",
    ianaId: "Etc/UTC",
    name: "(UTC) Coordinated Universal Time",
    abbreviation: "(UTC Standard Time)",
    offset: 0,
  },
  {
    id: "GMT Standard Time",
    ianaId: "Europe/London",
    name: "(UTC+00:00) Dublin, Edinburgh, Lisbon, London",
    abbreviation: "(GMT)",
    offset: 0,
  },
  {
    id: "Greenwich Standard Time",
    ianaId: "Atlantic/Reykjavik",
    name: "(UTC+00:00) Monrovia, Reykjavik",
    abbreviation: "(GMT)",
    offset: 0,
  },
  {
    id: "Sao Tome Standard Time",
    ianaId: "Africa/Sao_Tome",
    name: "(UTC+00:00) Sao Tome",
    abbreviation: "(GMT)",
    offset: 0,
  },
  {
    id: "Morocco Standard Time",
    ianaId: "Africa/Casablanca",
    name: "(UTC+01:00) Casablanca",
    abbreviation: "(WET)",
    offset: 1,
  },
  {
    id: "W. Europe Standard Time",
    ianaId: "Europe/Berlin",
    name: "(UTC+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna",
    abbreviation: "(CET)",
    offset: 1,
  },
  {
    id: "Central Europe Standard Time",
    ianaId: "Europe/Budapest",
    name: "(UTC+01:00) Belgrade, Bratislava, Budapest, Ljubljana, Prague",
    abbreviation: "(CET)",
    offset: 1,
  },
  {
    id: "Romance Standard Time",
    ianaId: "Europe/Paris",
    name: "(UTC+01:00) Brussels, Copenhagen, Madrid, Paris",
    abbreviation: "(CET)",
    offset: 1,
  },
  {
    id: "Central European Standard Time",
    ianaId: "Europe/Warsaw",
    name: "(UTC+01:00) Sarajevo, Skopje, Warsaw, Zagreb",
    abbreviation: "(CET)",
    offset: 1,
  },
  {
    id: "W. Central Africa Standard Time",
    ianaId: "Africa/Lagos",
    name: "(UTC+01:00) West Central Africa",
    abbreviation: "(WAT)",
    offset: 1,
  },
  {
    id: "Jordan Standard Time",
    ianaId: "Asia/Amman",
    name: "(UTC+02:00) Amman",
    abbreviation: "(EET)",
    offset: 2,
  },
  {
    id: "GTB Standard Time",
    ianaId: "Europe/Bucharest",
    name: "(UTC+02:00) Athens, Bucharest",
    abbreviation: "(EET)",
    offset: 2,
  },
  {
    id: "Middle East Standard Time",
    ianaId: "Asia/Beirut",
    name: "(UTC+02:00) Beirut",
    abbreviation: "(EET)",
    offset: 2,
  },
  {
    id: "Egypt Standard Time",
    ianaId: "Africa/Cairo",
    name: "(UTC+02:00) Cairo",
    abbreviation: "(EET)",
    offset: 2,
  },
  {
    id: "E. Europe Standard Time",
    ianaId: "Europe/Chisinau",
    name: "(UTC+02:00) Chisinau",
    abbreviation: "(EET)",
    offset: 2,
  },
  {
    id: "Syria Standard Time",
    ianaId: "Asia/Damascus",
    name: "(UTC+02:00) Damascus",
    abbreviation: "(EET)",
    offset: 2,
  },
  {
    id: "West Bank Standard Time",
    ianaId: "Asia/Hebron",
    name: "(UTC+02:00) Gaza, Hebron",
    abbreviation: "(EET)",
    offset: 2,
  },
  {
    id: "South Africa Standard Time",
    ianaId: "Africa/Johannesburg",
    name: "(UTC+02:00) Harare, Pretoria",
    abbreviation: "(SAST)",
    offset: 2,
  },
  {
    id: "FLE Standard Time",
    ianaId: "Europe/Kiev",
    name: "(UTC+02:00) Helsinki, Kyiv, Riga, Sofia, Tallinn, Vilnius",
    abbreviation: "(EET)",
    offset: 2,
  },
  {
    id: "Israel Standard Time",
    ianaId: "Asia/Jerusalem",
    name: "(UTC+02:00) Jerusalem",
    abbreviation: "(Israel Standard Time)",
    offset: 2,
  },
  {
    id: "Kaliningrad Standard Time",
    ianaId: "Europe/Kaliningrad",
    name: "(UTC+02:00) Kaliningrad",
    abbreviation: "(Kaliningrad Standard Time)",
    offset: 2,
  },
  {
    id: "Sudan Standard Time",
    ianaId: "Africa/Khartoum",
    name: "(UTC+02:00) Khartoum",
    abbreviation: "(CAT)",
    offset: 2,
  },
  {
    id: "Libya Standard Time",
    ianaId: "Africa/Tripoli",
    name: "(UTC+02:00) Tripoli",
    abbreviation: "(EET)",
    offset: 2,
  },
  {
    id: "Namibia Standard Time",
    ianaId: "Africa/Windhoek",
    name: "(UTC+02:00) Windhoek",
    abbreviation: "(CAT)",
    offset: 2,
  },
  {
    id: "Arabic Standard Time",
    ianaId: "Asia/Baghdad",
    name: "(UTC+03:00) Baghdad",
    abbreviation: "(Iraq Standard Time)",
    offset: 3,
  },
  {
    id: "Turkey Standard Time",
    ianaId: "Europe/Istanbul",
    name: "(UTC+03:00) Istanbul",
    abbreviation: "(Turkey Standard Time)",
    offset: 3,
  },
  {
    id: "Arab Standard Time",
    ianaId: "Asia/Riyadh",
    name: "(UTC+03:00) Kuwait, Riyadh",
    abbreviation: "(Saudi Arabia Standard Time)",
    offset: 3,
  },
  {
    id: "Belarus Standard Time",
    ianaId: "Europe/Minsk",
    name: "(UTC+03:00) Minsk",
    abbreviation: "(Belarus Standard Time)",
    offset: 3,
  },
  {
    id: "Russian Standard Time",
    ianaId: "Europe/Moscow",
    name: "(UTC+03:00) Moscow, St. Petersburg",
    abbreviation: "(Moscow Standard Time)",
    offset: 3,
  },
  {
    id: "E. Africa Standard Time",
    ianaId: "Africa/Nairobi",
    name: "(UTC+03:00) Nairobi",
    abbreviation: "(EAT)",
    offset: 3,
  },
  {
    id: "Iran Standard Time",
    ianaId: "Asia/Tehran",
    name: "(UTC+03:30) Tehran",
    abbreviation: "(Iran Standard Time)",
    offset: 3.5,
  },
  {
    id: "Arabian Standard Time",
    ianaId: "Asia/Dubai",
    name: "(UTC+04:00) Abu Dhabi, Muscat",
    abbreviation: "(GST)",
    offset: 4,
  },
  {
    id: "Astrakhan Standard Time",
    ianaId: "Europe/Astrakhan",
    name: "(UTC+04:00) Astrakhan, Ulyanovsk",
    abbreviation: "(Astrakhan Standard Time)",
    offset: 4,
  },
  {
    id: "Azerbaijan Standard Time",
    ianaId: "Asia/Baku",
    name: "(UTC+04:00) Baku",
    abbreviation: "(Azerbaijan Standard Time)",
    offset: 4,
  },
  {
    id: "Russia Time Zone 3",
    ianaId: "Europe/Samara",
    name: "(UTC+04:00) Izhevsk, Samara",
    abbreviation: "(Samara Standard Time)",
    offset: 4,
  },
  {
    id: "Mauritius Standard Time",
    ianaId: "Indian/Mauritius",
    name: "(UTC+04:00) Port Louis",
    abbreviation: "(Mauritius Standard Time)",
    offset: 4,
  },
  {
    id: "Saratov Standard Time",
    ianaId: "Europe/Saratov",
    name: "(UTC+04:00) Saratov",
    abbreviation: "(Saratov Standard Time)",
    offset: 4,
  },
  {
    id: "Georgian Standard Time",
    ianaId: "Asia/Tbilisi",
    name: "(UTC+04:00) Tbilisi",
    abbreviation: "(Georgia Standard Time)",
    offset: 4,
  },
  {
    id: "Volgograd Standard Time",
    ianaId: "Europe/Volgograd",
    name: "(UTC+04:00) Volgograd",
    abbreviation: "(Volgograd Standard Time)",
    offset: 4,
  },
  {
    id: "Caucasus Standard Time",
    ianaId: "Asia/Yerevan",
    name: "(UTC+04:00) Yerevan",
    abbreviation: "(Armenia Standard Time)",
    offset: 4,
  },
  {
    id: "Afghanistan Standard Time",
    ianaId: "Asia/Kabul",
    name: "(UTC+04:30) Kabul",
    abbreviation: "(Afghanistan Standard Time)",
    offset: 4.5,
  },
  {
    id: "West Asia Standard Time",
    ianaId: "Asia/Tashkent",
    name: "(UTC+05:00) Ashgabat, Tashkent",
    abbreviation: "(Uzbekistan Standard Time)",
    offset: 5,
  },
  {
    id: "Ekaterinburg Standard Time",
    ianaId: "Asia/Yekaterinburg",
    name: "(UTC+05:00) Ekaterinburg",
    abbreviation: "(Yekaterinburg Standard Time)",
    offset: 5,
  },
  {
    id: "Pakistan Standard Time",
    ianaId: "Asia/Karachi",
    name: "(UTC+05:00) Islamabad, Karachi",
    abbreviation: "(Pakistan Standard Time)",
    offset: 5,
  },
  {
    id: "Qyzylorda Standard Time",
    ianaId: "Asia/Qyzylorda",
    name: "(UTC+05:00) Qyzylorda",
    abbreviation: "(Kazakhstan Standard Time)",
    offset: 5,
  },
  {
    id: "India Standard Time",
    ianaId: "Asia/Kolkata",
    name: "(UTC+05:30) Chennai, Kolkata, Mumbai, New Delhi",
    abbreviation: "(IST)",
    offset: 5.5,
  },
  {
    id: "Sri Lanka Standard Time",
    ianaId: "Asia/Colombo",
    name: "(UTC+05:30) Sri Jayawardenepura",
    abbreviation: "(IST)",
    offset: 5.5,
  },
  {
    id: "Nepal Standard Time",
    ianaId: "Asia/Kathmandu",
    name: "(UTC+05:45) Kathmandu",
    abbreviation: "(Nepal Standard Time)",
    offset: 5.75,
  },
  {
    id: "Central Asia Standard Time",
    ianaId: "Asia/Almaty",
    name: "(UTC+06:00) Astana",
    abbreviation: "(Kazakhstan Standard Time)",
    offset: 6,
  },
  {
    id: "Bangladesh Standard Time",
    ianaId: "Asia/Dhaka",
    name: "(UTC+06:00) Dhaka",
    abbreviation: "(Bangladesh Standard Time)",
    offset: 6,
  },
  {
    id: "Omsk Standard Time",
    ianaId: "Asia/Omsk",
    name: "(UTC+06:00) Omsk",
    abbreviation: "(Omsk Standard Time)",
    offset: 6,
  },
  {
    id: "Myanmar Standard Time",
    ianaId: "Asia/Yangon",
    name: "(UTC+06:30) Yangon (Rangoon)",
    abbreviation: "(Myanmar (Burma) Standard Time)",
    offset: 6.5,
  },
  {
    id: "SE Asia Standard Time",
    ianaId: "Asia/Bangkok",
    name: "(UTC+07:00) Bangkok, Hanoi, Jakarta",
    abbreviation: "(Thailand Standard Time)",
    offset: 7,
  },
  {
    id: "Altai Standard Time",
    ianaId: "Asia/Barnaul",
    name: "(UTC+07:00) Barnaul, Gorno-Altaysk",
    abbreviation: "(Barnaul Standard Time)",
    offset: 7,
  },
  {
    id: "W. Mongolia Standard Time",
    ianaId: "Asia/Hovd",
    name: "(UTC+07:00) Hovd",
    abbreviation: "(Mongolia Standard Time)",
    offset: 7,
  },
  {
    id: "North Asia Standard Time",
    ianaId: "Asia/Krasnoyarsk",
    name: "(UTC+07:00) Krasnoyarsk",
    abbreviation: "(Krasnoyarsk Standard Time)",
    offset: 7,
  },
  {
    id: "N. Central Asia Standard Time",
    ianaId: "Asia/Novosibirsk",
    name: "(UTC+07:00) Novosibirsk",
    abbreviation: "(Novosibirsk Standard Time)",
    offset: 7,
  },
  {
    id: "Tomsk Standard Time",
    ianaId: "Asia/Tomsk",
    name: "(UTC+07:00) Tomsk",
    abbreviation: "(Tomsk Standard Time)",
    offset: 7,
  },
  {
    id: "China Standard Time",
    ianaId: "Asia/Shanghai",
    name: "(UTC+08:00) Beijing, Chongqing, Hong Kong, Urumqi",
    abbreviation: "(China Standard Time)",
    offset: 8,
  },
  {
    id: "North Asia East Standard Time",
    ianaId: "Asia/Irkutsk",
    name: "(UTC+08:00) Irkutsk",
    abbreviation: "(Irkutsk Standard Time)",
    offset: 8,
  },
  {
    id: "Singapore Standard Time",
    ianaId: "Asia/Singapore",
    name: "(UTC+08:00) Kuala Lumpur, Singapore",
    abbreviation: "(SGT)",
    offset: 8,
  },
  {
    id: "W. Australia Standard Time",
    ianaId: "Australia/Perth",
    name: "(UTC+08:00) Perth",
    abbreviation: "(AWST)",
    offset: 8,
  },
  {
    id: "Taipei Standard Time",
    ianaId: "Asia/Taipei",
    name: "(UTC+08:00) Taipei",
    abbreviation: "(Taiwan Standard Time)",
    offset: 8,
  },
  {
    id: "Ulaanbaatar Standard Time",
    ianaId: "Asia/Ulaanbaatar",
    name: "(UTC+08:00) Ulaanbaatar",
    abbreviation: "(Mongolia Standard Time)",
    offset: 8,
  },
  {
    id: "Aus Central W. Standard Time",
    ianaId: "Australia/Eucla",
    name: "(UTC+08:45) Eucla",
    abbreviation: "(ACWST)",
    offset: 8.75,
  },
  {
    id: "Transbaikal Standard Time",
    ianaId: "Asia/Chita",
    name: "(UTC+09:00) Chita",
    abbreviation: "(Chita Standard Time)",
    offset: 9,
  },
  {
    id: "Tokyo Standard Time",
    ianaId: "Asia/Tokyo",
    name: "(UTC+09:00) Osaka, Sapporo, Tokyo",
    abbreviation: "(Japan Standard Time)",
    offset: 9,
  },
  {
    id: "North Korea Standard Time",
    ianaId: "Asia/Pyongyang",
    name: "(UTC+09:00) Pyongyang",
    abbreviation: "(North Korea Standard Time)",
    offset: 9,
  },
  {
    id: "Korea Standard Time",
    ianaId: "Asia/Seoul",
    name: "(UTC+09:00) Seoul",
    abbreviation: "(South Korea Standard Time)",
    offset: 9,
  },
  {
    id: "Yakutsk Standard Time",
    ianaId: "Asia/Yakutsk",
    name: "(UTC+09:00) Yakutsk",
    abbreviation: "(Yakutsk Standard Time)",
    offset: 9,
  },
  {
    id: "Cen. Australia Standard Time",
    ianaId: "Australia/Adelaide",
    name: "(UTC+09:30) Adelaide",
    abbreviation: "(ACST)",
    offset: 9.5,
  },
  {
    id: "AUS Central Standard Time",
    ianaId: "Australia/Darwin",
    name: "(UTC+09:30) Darwin",
    abbreviation: "(ACST)",
    offset: 9.5,
  },
  {
    id: "E. Australia Standard Time",
    ianaId: "Australia/Brisbane",
    name: "(UTC+10:00) Brisbane",
    abbreviation: "(AEST)",
    offset: 10,
  },
  {
    id: "AUS Eastern Standard Time",
    ianaId: "Australia/Sydney",
    name: "(UTC+10:00) Canberra, Melbourne, Sydney",
    abbreviation: "(AEST)",
    offset: 10,
  },
  {
    id: "West Pacific Standard Time",
    ianaId: "Pacific/Port_Moresby",
    name: "(UTC+10:00) Guam, Port Moresby",
    abbreviation: "(Papua New Guinea Standard Time)",
    offset: 10,
  },
  {
    id: "Tasmania Standard Time",
    ianaId: "Australia/Hobart",
    name: "(UTC+10:00) Hobart",
    abbreviation: "(AEST)",
    offset: 10,
  },
  {
    id: "Vladivostok Standard Time",
    ianaId: "Asia/Vladivostok",
    name: "(UTC+10:00) Vladivostok",
    abbreviation: "(Vladivostok Standard Time)",
    offset: 10,
  },
  {
    id: "Lord Howe Standard Time",
    ianaId: "Australia/Lord_Howe",
    name: "(UTC+10:30) Lord Howe Island",
    abbreviation: "(LHST)",
    offset: 10.5,
  },
  {
    id: "Bougainville Standard Time",
    ianaId: "Pacific/Bougainville",
    name: "(UTC+11:00) Bougainville Island",
    abbreviation: "(Papua New Guinea Standard Time)",
    offset: 11,
  },
  {
    id: "Russia Time Zone 10",
    ianaId: "Asia/Srednekolymsk",
    name: "(UTC+11:00) Chokurdakh",
    abbreviation: "(Srednekolymsk Standard Time)",
    offset: 11,
  },
  {
    id: "Magadan Standard Time",
    ianaId: "Asia/Magadan",
    name: "(UTC+11:00) Magadan",
    abbreviation: "(Magadan Standard Time)",
    offset: 11,
  },
  {
    id: "Norfolk Standard Time",
    ianaId: "Pacific/Norfolk",
    name: "(UTC+11:00) Norfolk Island",
    abbreviation: "(Norfolk Island Standard Time)",
    offset: 11,
  },
  {
    id: "Sakhalin Standard Time",
    ianaId: "Asia/Sakhalin",
    name: "(UTC+11:00) Sakhalin",
    abbreviation: "(Sakhalin Standard Time)",
    offset: 11,
  },
  {
    id: "Central Pacific Standard Time",
    ianaId: "Pacific/Guadalcanal",
    name: "(UTC+11:00) Solomon Is., New Caledonia",
    abbreviation: "(Solomon Islands Standard Time)",
    offset: 11,
  },
  {
    id: "Russia Time Zone 11",
    ianaId: "Asia/Kamchatka",
    name: "(UTC+12:00) Anadyr, Petropavlovsk-Kamchatsky",
    abbreviation: "(Kamchatka Standard Time)",
    offset: 12,
  },
  {
    id: "New Zealand Standard Time",
    ianaId: "Pacific/Auckland",
    name: "(UTC+12:00) Auckland, Wellington",
    abbreviation: "(NZST)",
    offset: 12,
  },
  {
    id: "UTC+12",
    ianaId: "Etc/GMT-12",
    name: "(UTC+12:00) Coordinated Universal Time+12",
    abbreviation: "(UTC Standard Time+12)",
    offset: 12,
  },
  {
    id: "Fiji Standard Time",
    ianaId: "Pacific/Fiji",
    name: "(UTC+12:00) Fiji",
    abbreviation: "(Fiji Standard Time)",
    offset: 12,
  },
  {
    id: "Kamchatka Standard Time",
    ianaId: "Asia/Kamchatka",
    name: "(UTC+12:00) Petropavlovsk-Kamchatsky - Old",
    abbreviation: "(Kamchatka Standard Time)",
    offset: 12,
  },
  {
    id: "Chatham Islands Standard Time",
    ianaId: "Pacific/Chatham",
    name: "(UTC+12:45) Chatham Islands",
    abbreviation: "(CHAST)",
    offset: 12.75,
  },
  {
    id: "UTC+13",
    ianaId: "Etc/GMT-13",
    name: "(UTC+13:00) Coordinated Universal Time+13",
    abbreviation: "(UTC Standard Time+13)",
    offset: 13,
  },
  {
    id: "Tonga Standard Time",
    ianaId: "Pacific/Tongatapu",
    name: "(UTC+13:00) Nuku`alofa",
    abbreviation: "(Tonga Standard Time)",
    offset: 13,
  },
  {
    id: "Samoa Standard Time",
    ianaId: "Pacific/Apia",
    name: "(UTC+13:00) Samoa",
    abbreviation: "(Samoa Standard Time)",
    offset: 13,
  },
  {
    id: "Line Islands Standard Time",
    ianaId: "Pacific/Kiritimati",
    name: "(UTC+14:00) Kiritimati Island",
    abbreviation: "(Kiribati Standard Time)",
    offset: 14,
  },
];
