import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import { sendRpcRequest } from "../../services/apiClient";

export interface IApp {
  pkgName: string;
  appName: string;
  appVer: string;
  appVerInt: number;
  appIcon: string;
}

interface AppsState {
  allApps: IApp[];
  isLoadingAllApps: boolean;
}

const initialState: AppsState = {
  allApps: [],
  isLoadingAllApps: false,
};

export const fetchAppList = createAsyncThunk(
  "apps/fetchAllApps",
  async (deviceId: string, { rejectWithValue }) => {
    try {
      const response = await sendRpcRequest<{ list: IApp[] }>("apps.applist", {
        deviceId,
        wIcons: true,
      });

      return response.list;
    } catch (error) {
      if (typeof error === "object" && error !== null && "message" in error) {
        return rejectWithValue(error.message);
      }

      return rejectWithValue("Unknown error occurred");
    }
  }
);

const appsSlice = createSlice({
  name: "apps",
  initialState,
  reducers: {},
  extraReducers: (builder) => {
    builder
      .addCase(fetchAppList.pending, (state) => {
        state.isLoadingAllApps = true;
      })
      .addCase(fetchAppList.fulfilled, (state, action) => {
        state.isLoadingAllApps = false;
        state.allApps = action.payload;
      });
  },
});

export default appsSlice.reducer;
