import React from "react";
import "./Calls.css";
import SectionHeader from "../../layouts/SectionHeader";
import { MdInfoOutline } from "react-icons/md";
import CButton from "../../components/CButton";

const Calls: React.FC = () => {
  return (
    <div className="calls wrapper">
      <SectionHeader to="/home" />

      <div className="calls__content">
        <div>
          <div className="calls__content__header">
            <h3>Calls</h3>
            <MdInfoOutline className="calls__content__header__icon" />
          </div>

          <p className="calls__content__empty">No data</p>
        </div>

        <div className="calls__filter">
          <p className="calls__filter__title">Select Dates</p>

          <div className="calls__filter__dates">
            <div className="calls__filter__date">
              <label htmlFor="from">From</label>
              <input type="date" id="from" />
            </div>

            <div className="calls__filter__date">
              <label htmlFor="to">To</label>
              <input type="date" id="to" />
            </div>
          </div>

          <CButton title="Search" />
        </div>
      </div>
    </div>
  );
};

export default Calls;
