import React from "react";
import "./Recording.css";
import SectionHeader from "../../layouts/SectionHeader";
import { MdInfoOutline } from "react-icons/md";
import CButton from "../../components/CButton";

const Recording: React.FC = () => {
  return (
    <div className="recording wrapper">
      <SectionHeader to="/home" />

      <div className="recording__content">
        <div>
          <div className="recording__content__header">
            <h3>Recording</h3>
            <MdInfoOutline className="recording__content__header__icon" />
          </div>

          <p className="recording__content__empty">No data</p>
        </div>

        <div className="recording__filter">
          <p className="recording__filter__title">Select Dates</p>

          <div className="recording__filter__dates">
            <div className="recording__filter__date">
              <label htmlFor="from">From</label>
              <input type="date" id="from" />
            </div>

            <div className="recording__filter__date">
              <label htmlFor="to">To</label>
              <input type="date" id="to" />
            </div>
          </div>

          <CButton title="Search" />
        </div>
      </div>
    </div>
  );
};

export default Recording;
