import React, { useState } from "react";
import "./Messengers.css";
import SectionHeader from "../../layouts/SectionHeader";
import { MdInfoOutline } from "react-icons/md";
import CButton from "../../components/CButton";
import { MESSENGERS, type IMessenger } from "../../constants/messengers";

const Messengers: React.FC = () => {
  const [selectedMessenger, setSelectedMessenger] = useState<IMessenger>(
    MESSENGERS[0]
  );

  return (
    <div className="messengers wrapper">
      <SectionHeader to="/home" />

      <div className="messengers__content">
        <div>
          <div className="messengers__content__header">
            <h3>Messengers</h3>
            <MdInfoOutline className="messengers__content__header__icon" />
          </div>

          <p className="messengers__content__empty">No data</p>
        </div>

        <div className="messengers__filter">
          <p className="messengers__filter__title">Select App & Dates</p>

          <div className="messengers__filter__messengers">
            {MESSENGERS.map((messenger) => {
              const isSelected = selectedMessenger?.id === messenger.id;

              return (
                <div
                  key={messenger.id}
                  className={`messengers__filter__messenger ${
                    isSelected ? "selected" : ""
                  }`}
                  onClick={() => setSelectedMessenger(messenger)}
                >
                  {messenger.icon}
                  <p>{messenger.name}</p>
                </div>
              );
            })}
          </div>

          <div className="messengers__filter__dates">
            <div className="messengers__filter__date">
              <label htmlFor="from">From</label>
              <input type="date" id="from" />
            </div>

            <div className="messengers__filter__date">
              <label htmlFor="to">To</label>
              <input type="date" id="to" />
            </div>
          </div>

          <CButton title="Search" />
        </div>
      </div>
    </div>
  );
};

export default Messengers;
