import React from "react";
import "./Routes.css";
import SectionHeader from "../../layouts/SectionHeader";
import CButton from "../../components/CButton";
import { useTranslation } from "react-i18next";
import GoogleMapReact from "google-map-react";

const Routes: React.FC = () => {
  const { t } = useTranslation();

  return (
    <div className="routes wrapper">
      <SectionHeader to="/home" />

      <div className="routes__content">
        <div style={{ height: "67vh", width: "100%" }}>
          <GoogleMapReact
            defaultCenter={{ lat: 40.7128, lng: -74.006 }}
            defaultZoom={12}
            options={{ disableDefaultUI: true }}
          ></GoogleMapReact>
        </div>

        <div className="routes__filter">
          <p className="routes__filter__title">{t("common.selectTime")}</p>

          <div className="routes__filter__dates">
            <div className="routes__filter__date">
              <label htmlFor="from">{t("common.from")}</label>
              <div>
                <input type="date" id="from" />
                <input type="time" id="from-time" />
              </div>
            </div>

            <div className="routes__filter__date">
              <label htmlFor="to">{t("common.to")}</label>
              <div>
                <input type="date" id="to" />
                <input type="time" id="to-time" />
              </div>
            </div>
          </div>

          <CButton title={t("button.search")} />
        </div>
      </div>
    </div>
  );
};

export default Routes;
