import { configureStore } from "@reduxjs/toolkit";
import authSlice from "./slices/authSlice";
import accountSlice from "./slices/accountSlice";
import notificationSlice from "./slices/notificationSlice";
import deviceSlice from "./slices/deviceSlice";
import commandSlice from "./slices/commandSlice";
import appsSlice from "./slices/appsSlice";
import browserHistorySlice from "./slices/browserHistorySlice";
import callHistorySlice from "./slices/callHistorySlice";
import {
  useDispatch,
  useSelector,
  type TypedUseSelectorHook,
} from "react-redux";

export const store = configureStore({
  reducer: {
    auth: authSlice,
    account: accountSlice,
    notification: notificationSlice,
    device: deviceSlice,
    command: commandSlice,
    apps: appsSlice,
    browserHistory: browserHistorySlice,
    callHistory: callHistorySlice,
  },
});

export type RootState = ReturnType<typeof store.getState>;
export type AppDispatch = typeof store.dispatch;

export const useAppDispatch = () => useDispatch<AppDispatch>();
export const useAppSelector: TypedUseSelectorHook<RootState> = useSelector;
