import React, { useEffect } from "react";
import "./Home.css";
import { Sheet, type SheetRef } from "react-modal-sheet";
import { useRef } from "react";
import { FaRegMap } from "react-icons/fa";
import { Link } from "react-router-dom";
import { LuShield } from "react-icons/lu";
import {
  IoBatteryHalfOutline,
  IoCallOutline,
  IoGlobeSharp,
  IoPhonePortraitOutline,
  IoRecordingSharp,
} from "react-icons/io5";
import { PiChatsCircle } from "react-icons/pi";
import { IoMdInformationCircleOutline } from "react-icons/io";
import { RiDeleteBinLine } from "react-icons/ri";
import { BsPersonStanding } from "react-icons/bs";
import { useTranslation } from "react-i18next";
import {
  useAppDispatch,
  useAppSelector,
  type RootState,
} from "../../stores/store";
import { fetchDeviceData } from "../../stores/slices/deviceSlice";

const Home: React.FC = () => {
  const ref = useRef<SheetRef>(null);
  const { t } = useTranslation();
  const { deviceData, selectedDevice } = useAppSelector(
    (state: RootState) => state.device
  );
  const dispatch = useAppDispatch();

  useEffect(() => {
    dispatch(fetchDeviceData(selectedDevice?.id || ""));
  }, [selectedDevice, dispatch]);

  return (
    <>
      <Sheet
        ref={ref}
        isOpen={true}
        onClose={() => {}}
        initialSnap={1}
        snapPoints={[0.7, 0.425]}
        style={{ zIndex: 1 }}
      >
        <Sheet.Container
          style={{ boxShadow: "none" }}
          className="home__sheet__content"
        >
          <Sheet.Header />
          <Sheet.Content>
            <div className="home__sheet__info">
              <div className="home__sheet__status">
                <div>
                  <IoBatteryHalfOutline className="home__sheet__status__icon" />
                  <p>
                    {deviceData?.bat_level ? (
                      <>{deviceData?.bat_level}%</>
                    ) : (
                      <>0%</>
                    )}
                  </p>
                </div>
                <div>
                  <BsPersonStanding className="home__sheet__status__icon" />
                  <p>
                    {deviceData?.location.speed ? (
                      <>
                        {deviceData?.location.speed} {t("home.kmh")}
                      </>
                    ) : (
                      <>0 {t("home.kmh")}</>
                    )}
                  </p>
                </div>
              </div>

              <div className="home__sheet__device">
                <IoPhonePortraitOutline className="home__sheet__device__icon" />
                <p>{selectedDevice?.name}</p>
              </div>
            </div>

            <div className="home__menu">
              <Link to={"/home/routes"} className="home__menu__link">
                <FaRegMap className="home__menu__icon" />
                <p>{t("menu.routes")}</p>
              </Link>

              <Link to={"/home/manage-apps"} className="home__menu__link">
                <LuShield className="home__menu__icon" />
                <p>{t("menu.manageApps")}</p>
              </Link>

              <Link to={"/home/browser-history"} className="home__menu__link">
                <IoGlobeSharp className="home__menu__icon" />
                <p>{t("menu.browserHistory")}</p>
              </Link>

              <Link to={"/home/messengers"} className="home__menu__link">
                <PiChatsCircle className="home__menu__icon" />
                <p>{t("menu.messengers")}</p>
              </Link>

              <Link to={"/home/calls"} className="home__menu__link">
                <IoCallOutline className="home__menu__icon" />
                <p>{t("menu.calls")}</p>
              </Link>

              <Link to={"/home/permissions"} className="home__menu__link">
                <IoMdInformationCircleOutline className="home__menu__icon" />
                <p>{t("menu.permissions")}</p>
              </Link>

              <Link to={"/home/recording"} className="home__menu__link">
                <IoRecordingSharp className="home__menu__icon" />
                <p>{t("menu.recordingEnvironment")}</p>
              </Link>

              <div className="home__menu__link">
                <RiDeleteBinLine className="home__menu__icon" />
                <p>{t("menu.removeDevice")}</p>
              </div>
            </div>
          </Sheet.Content>
        </Sheet.Container>
      </Sheet>
    </>
  );
};

export default Home;
