import React, { useState } from "react";
import "./ManageApps.css";
import SectionHeader from "../../layouts/SectionHeader";
import { LuShield } from "react-icons/lu";
import {
  IoAlarmOutline,
  IoLockClosedOutline,
  IoLockOpenOutline,
} from "react-icons/io5";
import { Link } from "react-router-dom";
import { useTranslation } from "react-i18next";
import CModal from "../../components/CModal";
import CButton from "../../components/CButton";
import { useAppDispatch, useAppSelector, type RootState } from "../../stores/store";
import { blockDevice, unBlockDevice } from "../../stores/slices/commandSlice";

const ManageApps: React.FC = () => {
  const [isOpenLockDeviceModal, setIsOpenLockDeviceModal] = useState(false);
  const [isOpenUnLockDeviceModal, setIsOpenUnLockDeviceModal] = useState(false);
  const { t } = useTranslation();
  const { selectedDevice } = useAppSelector((state: RootState) => state.device)
  const { isLoadingBlockDevice, isLoadingUnBlockDevice } = useAppSelector((state: RootState) => state.command)
  const dispatch = useAppDispatch();

  const handleModalLockDevice = () => {
    setIsOpenLockDeviceModal((prev) => !prev);
  };

  const handleModalUnlockDevice = () => {
    setIsOpenUnLockDeviceModal((prev) => !prev);
  };

  const handleBlockDevice = async () => {
    try {
      await dispatch(blockDevice(selectedDevice?.id || ""));
    } catch (error) {
      console.error("Error blocking device:", error);
    } finally {
      handleModalLockDevice();
    }
  }

  const handleUnBlockDevice = async () => {
    try {
      await dispatch(unBlockDevice(selectedDevice?.id || ""));
    } catch (error) {
      console.error("Error blocking device:", error);
    } finally {
      handleModalUnlockDevice();
    }
  };

  return (
    <div className="manageapps wrapper">
      <SectionHeader to="/home" />

      <div className="manageapps__content">
        <h3 className="manageapps__content__title">{t("manage.usage")}</h3>

        <Link
          to={"/home/manage-apps/block-apps"}
          className="manageapps__content__link"
        >
          <LuShield className="manageapps__content__icon" />
          <p>{t("manage.blockUnwantedApps")}</p>
        </Link>

        <Link
          to={"/home/manage-apps/usage-limits"}
          className="manageapps__content__link"
        >
          <IoAlarmOutline className="manageapps__content__icon" />
          <p>{t("manage.setTimeLimit")}</p>
        </Link>

        <div
          className="manageapps__content__link"
          onClick={handleModalLockDevice}
        >
          <IoLockClosedOutline className="manageapps__content__icon" />
          <p>{t("manage.lockDevice")}</p>
        </div>

        <div
          className="manageapps__content__link"
          onClick={handleModalUnlockDevice}
        >
          <IoLockOpenOutline className="manageapps__content__icon" />
          <p>{t("manage.unlockDevice")}</p>
        </div>
      </div>

      <CModal
        isOpen={isOpenLockDeviceModal}
        onToggle={handleModalLockDevice}
        content={
          <div className="manageapps__modal">
            <h3 className="manageapps__modal__title">
              {t("manage.lockDeviceTitle")}
            </h3>
            <p className="manageapps__modal__desc">
              {t("manage.lockDeviceDesc")}
            </p>

            <div className="manageapps__modal__actions">
              <CButton
                title={t("common.no")}
                variant="danger"
                onClick={handleModalLockDevice}
              />
              <CButton 
                title={t("common.yes")} 
                onClick={handleBlockDevice} 
                isLoading={isLoadingBlockDevice}
              />
            </div>
          </div>
        }
      />

      <CModal
        isOpen={isOpenUnLockDeviceModal}
        onToggle={handleModalUnlockDevice}
        content={
          <div className="manageapps__modal">
            <h3 className="manageapps__modal__title">
              {t("manage.unlockDeviceTitle")}
            </h3>
            <p className="manageapps__modal__desc">
              {t("manage.unlockDeviceDesc")}
            </p>

            <div className="manageapps__modal__actions">
              <CButton
                title={t("common.no")}
                variant="danger"
                onClick={handleModalUnlockDevice}
              />
              <CButton 
                title={t("common.yes")}
                onClick={handleUnBlockDevice}
                isLoading={isLoadingUnBlockDevice}
              />
            </div>
          </div>
        }
      />
    </div>
  );
};

export default ManageApps;
