import React from "react";
import { Navigate } from "react-router-dom";
import { useAuth } from "../contexts/AuthContext/AuthContext";

const AuthRedirect: React.FC = () => {
  const { isAuthenticated } = useAuth();
  return <Navigate to={isAuthenticated ? "/home" : "/auth/login"} replace />;
};

export default AuthRedirect;
