import React from "react";
import { Navigate } from "react-router-dom";
import { useAuth } from "../contexts/AuthContext/AuthContext";

interface ProtectedRouteProps {
  element: React.ReactElement;
  redirectTo: string;
}

const ProtectedRoute: React.FC<ProtectedRouteProps> = ({
  element,
  redirectTo,
}) => {
  const { isAuthenticated } = useAuth();

  return isAuthenticated ? element : <Navigate to={redirectTo} replace />;
};

export default ProtectedRoute;
