import React from "react";
import { createBrowserRouter, RouterProvider } from "react-router-dom";
import NotFound from "../pages/NotFound";
import Login from "../pages/Auth/Login";
import Register from "../pages/Auth/Register";
import Recover from "../pages/Auth/Recover";
import Layout from "./Layout";
import ProtectedRoute from "./ProtectedRoute";
import Home from "../pages/Home";
import Notifications from "../pages/Notifications";
import Subscription from "../pages/Subscription";
import Settings from "../pages/Settings";
import AuthRedirect from "./AuthRedirect";
import AuthGuardReverse from "./AuthGuardReverse";

const router = createBrowserRouter([
  {
    path: "/",
    element: <AuthRedirect />,
  },
  {
    path: "/auth",
    children: [
      {
        path: "login",
        element: <AuthGuardReverse component={<Login />} />,
      },
      {
        path: "register",
        element: <AuthGuardReverse component={<Register />} />,
      },
      {
        path: "recover",
        element: <AuthGuardReverse component={<Recover />} />,
      },
    ],
  },
  {
    path: "/",
    element: <ProtectedRoute element={<Layout />} redirectTo="/auth/login" />,
    children: [
      {
        path: "home",
        element: <Home />,
      },
      {
        path: "notifications",
        element: <Notifications />,
      },
      {
        path: "subscription",
        element: <Subscription />,
      },
      {
        path: "settings",
        element: <Settings />,
      },
    ],
  },
  {
    path: "*",
    element: <NotFound />,
  },
]);

const Router: React.FC = () => <RouterProvider router={router} />;

export default Router;
