import React from "react";
import "./Subscription.css";
import CButton from "../../components/CButton";
import { useTranslation } from "react-i18next";

const tariffs = [
  {
    id: 1,
    title: "Yearly",
    amount: 25,
  },
  {
    id: 2,
    title: "3-Months",
    amount: 15,
  },
  {
    id: 3,
    title: "Monthly",
    amount: 10,
  },
];

const paymentMethods = [
  {
    id: 1,
    paymethod_name: "Карта РФ: Мир, Visa, Mastercard",
  },
  {
    id: 2,
    paymethod_name: "СБП (Все банки РФ)",
  },
  {
    id: 3,
    paymethod_name: "МИР",
  },
];

const Subscription: React.FC = () => {
  const { t } = useTranslation();

  return (
    <div className="subscription wrapper">
      <div className="subscription__tariffs">
        <h3 className="subscription__tariffs__title">
          {t("subscription.selectTariff")}
        </h3>

        <div className="subscription__tariffs__list">
          {tariffs.map((tariff) => (
            <div key={tariff.id} className="subscription__tariff">
              <h4 className="subscription__tariff__title">{tariff.title}</h4>
              <p className="subscription__tariff__amount">${tariff.amount}</p>
            </div>
          ))}
        </div>
      </div>

      <div className="subscription__payments">
        <h3 className="subscription__payments__title">
          {t("subscription.selectPaymentMethod")}
        </h3>

        <div className="subscription__payments__list">
          {paymentMethods.map((method) => (
            <div key={method.id} className="subscription__payment">
              <p className="subscription__payment__name">
                {method.paymethod_name}
              </p>
            </div>
          ))}
        </div>
      </div>

      <CButton title={t("subscription.pay")} />
    </div>
  );
};

export default Subscription;
