import React from "react";
import "./ManageApps.css";
import SectionHeader from "../../layouts/SectionHeader";
import { LuShield } from "react-icons/lu";
import {
  IoAlarmOutline,
  IoLockClosedOutline,
  IoLockOpenOutline,
} from "react-icons/io5";
import { Link } from "react-router-dom";
import { useTranslation } from "react-i18next";

const ManageApps: React.FC = () => {
  const { t } = useTranslation();

  return (
    <div className="manageapps wrapper">
      <SectionHeader to="/home" />

      <div className="manageapps__content">
        <h3 className="manageapps__content__title">{t("manage.usage")}</h3>

        <Link
          to={"/home/manage-apps/block-apps"}
          className="manageapps__content__link"
        >
          <LuShield className="manageapps__content__icon" />
          <p>{t("manage.blockUnwantedApps")}</p>
        </Link>

        <Link
          to={"/home/manage-apps/usage-limits"}
          className="manageapps__content__link"
        >
          <IoAlarmOutline className="manageapps__content__icon" />
          <p>{t("manage.setTimeLimit")}</p>
        </Link>

        <div className="manageapps__content__link">
          <IoLockClosedOutline className="manageapps__content__icon" />
          <p>{t("manage.lockDevice")}</p>
        </div>

        <div className="manageapps__content__link">
          <IoLockOpenOutline className="manageapps__content__icon" />
          <p>{t("manage.unlockDevice")}</p>
        </div>
      </div>
    </div>
  );
};

export default ManageApps;
