import React from "react";
import "./AuthHeader.css";
import CSelect from "../../../components/CSelect";
import en from "../../../assets/images/flag-en.png";
import ru from "../../../assets/images/flag-ru.png";
import uz from "../../../assets/images/flag-uz.png";
import { useLanguage } from "../../../contexts/LanguageContext/useLanguage";
import type { AuthHeaderProps } from "./AuthHeader.types";
import { IoArrowBack } from "react-icons/io5";

const AuthHeader: React.FC<AuthHeaderProps> = ({ back, onBack }) => {
  const { language, changeLanguage } = useLanguage();

  return (
    <div className="authheader">
      {back && <IoArrowBack onClick={onBack} className="header__back" />}

      <CSelect
        value={language}
        onChange={(flag: string) => changeLanguage(flag as "en" | "ru" | "uz")}
        options={[
          {
            label: "English",
            value: "en",
            image: (
              <img
                src={en}
                alt="en"
                style={{ width: 20, height: 20, objectFit: "cover" }}
              />
            ),
          },
          {
            label: "Русский",
            value: "ru",
            image: (
              <img
                src={ru}
                alt="ru"
                style={{ width: 20, height: 20, objectFit: "cover" }}
              />
            ),
          },
          {
            label: "Uzbek",
            value: "uz",
            image: (
              <img
                src={uz}
                alt="uz"
                style={{ width: 20, height: 20, objectFit: "cover" }}
              />
            ),
          },
        ]}
      />
    </div>
  );
};

export default AuthHeader;
