import React, { useEffect } from "react";
import Router from "./routes/Router";
import useTelegramExpand from "./hooks/useTelegramExpand";
import { TG_USER_ID } from "./constants/constants";
import { useAppDispatch } from "./stores/store";
import { fetchDevices } from "./stores/slices/deviceSlice";

const App: React.FC = () => {
  const dispatch = useAppDispatch();

  useTelegramExpand();

  useEffect(() => {
    if (localStorage.getItem(`token-${TG_USER_ID}`)) {
      dispatch(fetchDevices());
    }
  }, [dispatch]);

  return <Router />;
};

export default App;
