import React, { useState } from "react";
import "./Recording.css";
import SectionHeader from "../../layouts/SectionHeader";
import { MdInfoOutline } from "react-icons/md";
import CButton from "../../components/CButton";
import { useTranslation } from "react-i18next";
import { FaMicrophoneLines } from "react-icons/fa6";
import { FaImage } from "react-icons/fa";

const Recording: React.FC = () => {
  const [selectedTab, setSelectedTab] = useState<"audio" | "image">("audio");
  const { t } = useTranslation();

  const renderTabContent = () => {
    switch (selectedTab) {
      case "audio":
        return (
          <div className="recording__content">
            <div>
              <div className="recording__content__header">
                <h3>{t("recording.audioFiles")}</h3>
                <MdInfoOutline className="recording__content__header__icon" />
              </div>

              <p className="recording__content__empty">
                {t("recording.audioFilesEmpty")}
              </p>
            </div>

            <div className="recording__filter">
              <p className="recording__filter__title">
                {t("common.selectAppAndDates")}
              </p>

              <div className="recording__filter__dates">
                <div className="recording__filter__date">
                  <label htmlFor="from">{t("common.from")}</label>
                  <input type="date" id="from" />
                </div>

                <div className="recording__filter__date">
                  <label htmlFor="to">{t("common.to")}</label>
                  <input type="date" id="to" />
                </div>
              </div>

              <CButton title={t("button.search")} />
            </div>
          </div>
        );
      case "image":
        return (
          <div className="recording__content">
            <div>
              <div className="recording__content__header">
                <h3>{t("recording.imageFiles")}</h3>
                <MdInfoOutline className="recording__content__header__icon" />
              </div>

              <p className="recording__content__empty">
                {t("recording.imageFilesEmpty")}
              </p>
            </div>

            <div className="recording__filter">
              <p className="recording__filter__title">
                {t("common.selectAppAndDates")}
              </p>

              <div className="recording__filter__dates">
                <div className="recording__filter__date">
                  <label htmlFor="from">{t("common.from")}</label>
                  <input type="date" id="from" />
                </div>

                <div className="recording__filter__date">
                  <label htmlFor="to">{t("common.to")}</label>
                  <input type="date" id="to" />
                </div>
              </div>

              <CButton title={t("button.search")} />
            </div>
          </div>
        );
      default:
        return null;
    }
  };

  return (
    <div className="recording wrapper">
      <SectionHeader to="/home" />

      {renderTabContent()}

      <div className="recording__tabs">
        <div
          onClick={() => setSelectedTab("audio")}
          className={`recording__tab ${
            selectedTab === "audio" ? "active" : ""
          }`}
        >
          <FaMicrophoneLines />
          <p>{t("recording.audio")}</p>
        </div>

        <div
          onClick={() => setSelectedTab("image")}
          className={`recording__tab ${
            selectedTab === "image" ? "active" : ""
          }`}
        >
          <FaImage />
          <p>{t("recording.image")}</p>
        </div>
      </div>
    </div>
  );
};

export default Recording;
