import React, { useState } from "react";
import "./Settings.css";
import { useLanguage } from "../../contexts/LanguageContext/useLanguage";
import CSelect from "../../components/CSelect";
import en from "../../assets/images/flag-en.png";
import ru from "../../assets/images/flag-ru.png";
import { FiUserMinus } from "react-icons/fi";
import { IoKeyOutline } from "react-icons/io5";
import { MdOutlineLogout } from "react-icons/md";
import { useTranslation } from "react-i18next";
import { useAppDispatch } from "../../stores/store";
import { logout } from "../../stores/slices/authSlice";
import CModal from "../../components/CModal";
import CButton from "../../components/CButton";
import { Link } from "react-router-dom";

const Settings: React.FC = () => {
  const [isOpenLogoutModal, setIsOpenLogoutModal] = useState(false);
  const { language, changeLanguage } = useLanguage();
  const { t } = useTranslation();
  const dispatch = useAppDispatch();

  const toggleLogoutModal = () => {
    setIsOpenLogoutModal((prev) => !prev);
  };

  return (
    <div className="settings">
      <h3 className="settings__title">{t("settings.title")}</h3>

      <div className="settings__content">
        <CSelect
          value={language}
          onChange={(flag: string) => changeLanguage(flag as "en" | "ru")}
          options={[
            {
              label: "English",
              value: "en",
              image: (
                <img
                  src={en}
                  alt="en"
                  style={{ width: 20, height: 20, objectFit: "cover" }}
                />
              ),
            },
            {
              label: "Русский",
              value: "ru",
              image: (
                <img
                  src={ru}
                  alt="ru"
                  style={{ width: 20, height: 20, objectFit: "cover" }}
                />
              ),
            },
          ]}
        />

        <h3>{t("settings.account")}</h3>

        <div className="settings__content__action">
          <FiUserMinus className="settings__content__action__icon" />{" "}
          {t("settings.deleteAccount")}
        </div>

        <Link
          to={"/settings/recover-password"}
          className="settings__content__action"
        >
          <IoKeyOutline className="settings__content__action__icon" />{" "}
          {t("settings.recoverPassword")}
        </Link>

        <div className="settings__content__action" onClick={toggleLogoutModal}>
          <MdOutlineLogout className="settings__content__action__icon" />{" "}
          {t("settings.logout")}
        </div>
      </div>

      <CModal
        isOpen={isOpenLogoutModal}
        onToggle={toggleLogoutModal}
        content={
          <div className="modal__box">
            <h3 className="modal__box__title">{t("logout.title")}</h3>
            <p>{t("logout.desc")}</p>
            <div className="modal__box__actions">
              <CButton title={t("button.cancel")} onClick={toggleLogoutModal} />
              <CButton
                title={t("button.logout")}
                variant="danger"
                onClick={() => dispatch(logout())}
              />
            </div>
          </div>
        }
      />
    </div>
  );
};

export default Settings;
